#
# (C) Tenable Network Security
#

if(description)
{
 script_id(16469);
 script_version("$Revision: 1.7 $");

 script_cve_id("CVE-2005-0439", "CVE-2005-0440");
 script_bugtraq_id(12556, 12639, 12640);

 name["english"] = "ELOG Web Logbook Multiple Remote Vulnerabilities";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote web server is affected by multiple issues.

Description :

The remote host is running ELOG Web Logbook, a free webinterface
logbook. 

According to its banner, the version of ELOG Web Logbook installed on
the remote host contains a buffer overflow that can be triggered when
handing attachment with names longer than 256 characters to execute
code on the remote host subject to the permissions under which ELOG
operates. 

In addition, it is possible to retrieve a copy of the application's
config file and discover a form of its write password.  By default,
the value is encoded using Base-64, although it might be encrypted if
elog was compiled with '-DHAVE_CRYPT'. 

See also :

http://midas.psi.ch/elogs/Forum/941

Solution : 

Upgrade to version 2.5.7 or later.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the presence of ELOG Web Logbook";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005-2008 Tenable Network Security");
 script_family(english:"CGI abuses");
 
 script_dependencies("http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if ( ! port ) exit(0);

function check(url)
{
 local_var req, res;
 global_var port;

 req = http_get(item:url +"/?cmd=Config", port:port);
 res = http_keepalive_send_recv(port:port, data:req);
 if ( res == NULL ) exit(0);
 if ( egrep(pattern:"^<center><a class=.*Goto ELOG home page.*midas\.psi\.ch/elog/.*ELOG V([0-1]\.|2\.([0-4]\.|5\.[0-6][^0-9]))", string:res) ) 
 {
        security_hole(port);
        exit(0);
 }
}

check(url:"/elog");
foreach dir ( cgi_dirs() )
{
  check(url:dir);
}
