#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(16028);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CVE-2004-0971", "CVE-2004-1189");
 
 name["english"] = "Fedora Core 2 2004-563: krb5";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2004-563 (krb5).

Kerberos V5 is a trusted-third-party network authentication system,
which can improve your network's security by eliminating the insecure
practice of cleartext passwords.

A heap based buffer overflow bug was found in the administration
library of Kerberos 1.3.5 and earlier. This overflow in the password
history handling code could allow an authenticated remote attacker to
execute commands on a realm's master Kerberos KDC. The Common
Vulnerabilities and Exposures project (cve.mitre.org) has assigned
the name CVE-2004-1189 to this issue.

Additionally a temporary file bug was found in the Kerberos
krb5-send-pr command. It is possible that an attacker could create a
specially crafted temporary file that could allow an arbitrary file
to be overwritten which the victim has write access to. The Common
Vulnerabilities and Exposures project (cve.mitre.org) has assigned
the name CVE-2004-0971 to this issue.


* Mon Dec 20 2004 Nalin Dahyabhai 1.3.6-1

- update to 1.3.6, which includes the previous fix

* Mon Dec 20 2004 Nalin Dahyabhai 1.3.5-8

- apply fix from Tom Yu for MITKRB5-SA-2004-004 (CVE-2004-1189)

* Fri Dec 17 2004 Martin Stransky 1.3.5-7

- fix deadlock during file transfer via rsync/krsh
- thanks goes to James Antil for hint

* Fri Nov 26 2004 Nalin Dahyabhai 1.3.5-6

- rebuild

* Mon Nov 22 2004 Nalin Dahyabhai 1.3.5-3

- fix predictable-tempfile-name bug in krb5-send-pr (CVE-2004-0971,
#140036)

* Tue Nov 16 2004 Nalin Dahyabhai

- silence compiler warning in kprop by using an in-memory ccache with
a fixed
name instead of an on-disk ccache with a name generated by tmpnam()

* Tue Nov 16 2004 Nalin Dahyabhai 1.3.5-2

- fix globbing patch port mode (#139075)

* Mon Nov 01 2004 Nalin Dahyabhai 1.3.5-1

- fix segfault in telnet due to incorrect checking of gethostbyname_r
result
codes (#129059)

* Fri Oct 15 2004 Nalin Dahyabhai

- remove rc4-hmac:norealm and rc4-hmac:onlyrealm from the default list
of
supported keytypes in kdc.conf - they produce exactly the same keys as
rc4-hmac:normal because rc4 string-to-key ignores salts
- nuke kdcrotate - there are better ways to balance the load on KDCs,
and
the SELinux policy for it would have been scary-looking
- update to 1.3.5, mainly to include MITKRB5SA 2004-002 and 2004-003

* Tue Aug 31 2004 Nalin Dahyabhai 1.3.4-7

- rebuild

* Tue Aug 24 2004 Nalin Dahyabhai 1.3.4-6

- rebuild



Solution : http://www.fedoranews.org/blog/index.php?p=218
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the krb5 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"krb5-devel-1.3.6-1", release:"FC2") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-libs-1.3.6-1", release:"FC2") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-server-1.3.6-1", release:"FC2") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-workstation-1.3.6-1", release:"FC2") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"krb5-debuginfo-1.3.6-1", release:"FC2") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"krb5-", release:"FC2") )
{
 set_kb_item(name:"CVE-2004-0971", value:TRUE);
 set_kb_item(name:"CVE-2004-1189", value:TRUE);
}
