#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24089);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-0748", "CVE-2006-0884", "CVE-2006-1045", "CVE-2006-1727", "CVE-2006-1735", "CVE-2006-1737", "CVE-2006-1741", "CVE-2006-1742", "CVE-2006-1790");
 
 name["english"] = "Fedora Core 4 2006-489: thunderbird";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2006-489 (thunderbird).

Mozilla Thunderbird is a standalone mail and newsgroup client.

Update Information:

Updated thunderbird packages that fix various bugs are now
available for Fedora Core 4.

This update has been rated as having critical security
impact by the Fedora Security Response Team.

Mozilla Thunderbird is a standalone mail and newsgroup client.

Several bugs were found in the way Thunderbird processes
malformed javascript. A malicious HTML mail message could
modify the content of a different open HTML mail message,
possibly stealing sensitive information or conducting a
cross-site scripting attack. Please note that JavaScript
support is disabled by default in Thunderbird.
(CVE-2006-1731, CVE-2006-1732, CVE-2006-1741)

Several bugs were found in the way Thunderbird processes
certain javascript actions. A malicious HTML mail message
could execute arbitrary javascript instructions with the
permissions of 'chrome', allowing the page to steal
sensitive information or install browser malware. Please
note that JavaScript support is disabled by default in
Thunderbird. (CVE-2006-0292, CVE-2006-0296, CVE-2006-1727,
CVE-2006-1728, CVE-2006-1733, CVE-2006-1734, CVE-2006-1735,
CVE-2006-1742)

Several bugs were found in the way Thunderbird processes
malformed HTML mail messages. A carefully crafted malicious
HTML mail message could cause the execution of arbitrary
code as the user running Thunderbird. (CVE-2006-0748,
CVE-2006-0749, CVE-2006-1724, CVE-2006-1730, CVE-2006-1737,
CVE-2006-1738, CVE-2006-1739, CVE-2006-1790)

A bug was found in the way Thunderbird processes certain
inline content in HTML mail messages. It may be possible for
a remote attacker to send a carefully crafted mail message
to the victim, which will fetch remote content, even if
Thunderbird is configured not to fetch remote content.
(CVE-2006-1045)

A bug was found in the way Thunderbird executes in-line mail
forwarding. If a user can be tricked into forwarding a
maliciously crafted mail message as in-line content, it is
possible for the message to execute javascript with the
permissions of 'chrome'. (CVE-2006-0884)

Users of Thunderbird are advised to upgrade to these updated
packages containing Thunderbird version 1.0.8, which is not
vulnerable to these issues.



Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the thunderbird package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"thunderbird-1.0.8-1.1.fc4", prefix:"thunderbird-", release:"FC4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"thunderbird-", release:"FC4") )
{
 set_kb_item(name:"CVE-2006-0748", value:TRUE);
 set_kb_item(name:"CVE-2006-0884", value:TRUE);
 set_kb_item(name:"CVE-2006-1045", value:TRUE);
 set_kb_item(name:"CVE-2006-1727", value:TRUE);
 set_kb_item(name:"CVE-2006-1735", value:TRUE);
 set_kb_item(name:"CVE-2006-1737", value:TRUE);
 set_kb_item(name:"CVE-2006-1741", value:TRUE);
 set_kb_item(name:"CVE-2006-1742", value:TRUE);
 set_kb_item(name:"CVE-2006-1790", value:TRUE);
}
