#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24097);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-1527", "CVE-2006-1863");
 
 name["english"] = "Fedora Core 4 2006-500: kernel";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2006-500 (kernel).

The kernel package contains the Linux kernel (vmlinuz), the core of any
Linux operating system.  The kernel handles the basic functions
of the operating system:  memory allocation, process allocation, device
input and output, etc.

Update Information:

An update to the latest upstream -stable snapshot (2.6.16.13)

Among quite a few bug-fixes, are two security related fixes:

Don't allow a backslash in a path component  (CVE-2006-1863)
NETFILTER: SCTP conntrack: fix infinite loop (CVE-2006-1527)

Detailed changelogs of the last few point releases can be
found at:

[8]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.16.10
[9]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.16.11
[10]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.16.12
[11]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.16.13

Fedora specific changelog detailed below.



Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"kernel-2.6.16-1.2107_FC4", prefix:"kernel-", release:"FC4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"kernel-", release:"FC4") )
{
 set_kb_item(name:"CVE-2006-1527", value:TRUE);
 set_kb_item(name:"CVE-2006-1863", value:TRUE);
}
