#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24139);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-2198", "CVE-2006-2199", "CVE-2006-3117");
 
 name["english"] = "Fedora Core 5 2006-770: openoffice.org";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2006-770 (openoffice.org).

OpenOffice.org is an Open Source, community-developed, multi-platform
office productivity suite.  It includes the key desktop applications,
such as a word processor, spreadsheet, presentation manager, formula
editor and drawing program, with a user interface and feature set
similar to other office suites.  Sophisticated and flexible,
OpenOffice.org also works transparently with a variety of file
formats, including Microsoft Office.

Usage: Simply type 'ooffice' to run OpenOffice.org or select the
requested component (Writer, Calc, Draw, Impress, etc.) from your
desktop menu. On first start a few files will be installed in the
user's home, if necessary.

The OpenOffice.org team hopes you enjoy working with OpenOffice.org!

Update Information:

- CVE-2006-2198 macro security
- CVE-2006-2199 java applets
- CVE-2006-3117 corrupt file format
more details at
[8]http://www.openoffice.org/security/bulletin-20060629.html


Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the openoffice.org package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"openoffice.org-2.0.2-5.16.2", prefix:"openoffice.org-", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"openoffice.org-", release:"FC5") )
{
 set_kb_item(name:"CVE-2006-2198", value:TRUE);
 set_kb_item(name:"CVE-2006-2199", value:TRUE);
 set_kb_item(name:"CVE-2006-3117", value:TRUE);
}
