#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24150);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "Fedora Core 5 2006-823: vixie-cron";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2006-823 (vixie-cron).

The vixie-cron package contains the Vixie version of cron.  Cron is a
standard UNIX daemon that runs specified programs at scheduled times.
Vixie cron adds better security and more powerful configuration
options to the standard version of cron.



Update information :

* Fri Jul 14 2006 Jason Vas Dias <jvdias redhat com> - 4:4.1-55.FC5
- fix bug 198893 - change permissions of cron spool directories to 0700
- fix bug 191823: fix missing BuildRequires: audit-libs-devel



Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the vixie-cron package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"vixie-cron-4.1-55.FC5", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
