#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24159);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2005-3964");
 
 name["english"] = "Fedora Core 4 2006-854: openmotif";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2006-854 (openmotif).

This is the Open Motif 2.2.3 runtime environment. It includes the
Motif shared libraries, needed to run applications which are dynamically
linked against Motif, and the Motif Window Manager 'mwm'.



Update information :

* Wed Mar 29 2006 Thomas Woerner <twoerner redhat com> 2.2.3-10.FC4.2
- fixed CVE-2005-3964: libUil buffer overflows (#174815)



Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the openmotif package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"openmotif-2.2.3-10.FC4.2", prefix:"openmotif-", release:"FC4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"openmotif-", release:"FC4") )
{
 set_kb_item(name:"CVE-2005-3964", value:TRUE);
}
