#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24168);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "Fedora Core 5 2006-903: thunderbird";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2006-903 (thunderbird).

Mozilla Thunderbird is a standalone mail and newsgroup client.

Update Information:

Several security issues have been identified that are fixed
in this release. Please refer to
[8]http://www.mozilla.org/projects/security/known-vulnerabilities.html#thunderb
ird1.5.0.5
for details.

Users of Thunderbird are advised to update to this package,
which contains version 1.5.0.5 of Thunderbird and is not
vulnerable to these issues.



Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the thunderbird package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"thunderbird-1.5.0.5-1.1.fc5", prefix:"thunderbird-", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
