#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24170);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-3467");
 
 name["english"] = "Fedora Core 5 2006-912: libXfont";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2006-912 (libXfont).

X.Org X11 libXfont runtime library



Update information :

* Mon Aug 14 2006 Soren Sandmann <sandmann redhat com> - 1.0.0-3
- fdo-7535.patch
Fix for FDO bug 7535, CVE-2006-3467, RH bug 202475



Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libXfont package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libXfont-devel-1.0.0-3", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libXfont-1.0.0-3", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"libXfont-", release:"FC5") )
{
 set_kb_item(name:"CVE-2006-3467", value:TRUE);
}
