#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24176);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-4339");
 
 name["english"] = "Fedora Core 5 2006-953: openssl097a";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2006-953 (openssl097a).

The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

Update Information:

This is a security update for CVE-2006-4339.
Avoid PKCS #1 v1.5 signature attack discovered by Daniel
Bleichenbacher [Ben Laurie; Google Security Team]




Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the openssl097a package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"openssl097a-0.9.7a-4.2.2", prefix:"openssl097a-", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"openssl097a-", release:"FC5") )
{
 set_kb_item(name:"CVE-2006-4339", value:TRUE);
}
