#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24181);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-4253", "CVE-2006-4566", "CVE-2006-4567", "CVE-2006-4570", "CVE-2006-4571");
 
 name["english"] = "Fedora Core 5 2006-977: thunderbird";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2006-977 (thunderbird).

Mozilla Thunderbird is a standalone mail and newsgroup client.

Update Information:

Mozilla Thunderbird is a standalone mail and newsgroup client.

Two flaws were found in the way Thunderbird processed
certain regular expressions. A malicious HTML email could
cause a crash or possibly execute arbitrary code as the user
running Thunderbird. (CVE-2006-4565, CVE-2006-4566)

A flaw was found in the Thunderbird auto-update verification
system. An attacker who has the ability to spoof a victim's
DNS could get Firefox to download and install malicious
code. In order to exploit this issue an attacker would also
need to get a victim to previously accept an unverifiable
certificate. (CVE-2006-4567)

A flaw was found in the handling of JavaScript timed events.
A malicious HTML email could crash the browser or possibly
execute arbitrary code as the user running Thunderbird.
(CVE-2006-4253)

A flaw was found in Thunderbird that triggered when a HTML
message contained a remote image pointing to a XBL script.
An attacker could have created a carefully crafted message
which would execute JavaScript if certain actions were
performed on the email by the recipient, even if JavaScript
was disabled. (CVE-2006-4570)

A number of flaws were found in Thunderbird. A malicious
HTML email could cause a crash or possibly execute arbitrary
code as the user running Thunderbird. (CVE-2006-4571)

Users of Thunderbird are advised to upgrade to this update,
which contains Thunderbird version 1.5.0.7 that corrects
these issues.


Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the thunderbird package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"thunderbird-1.5.0.7-1.fc5", prefix:"thunderbird-", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"thunderbird-", release:"FC5") )
{
 set_kb_item(name:"CVE-2006-4253", value:TRUE);
 set_kb_item(name:"CVE-2006-4566", value:TRUE);
 set_kb_item(name:"CVE-2006-4567", value:TRUE);
 set_kb_item(name:"CVE-2006-4570", value:TRUE);
 set_kb_item(name:"CVE-2006-4571", value:TRUE);
}
