#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-0001 (epiphany).

epiphany is a simple GNOME web browser based on the Mozilla rendering
engine.

-
Update Information:

Updated firefox packages that fix several security bugs are now available for F
edora Core 7.

Users of epiphany are advised to upgrade to these erratum packages which have b
een rebuilt against a patched firefox which is not vulnerable to these issues.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27648);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-1362", "CVE-2007-1562", "CVE-2007-2867", "CVE-2007-2868", "CVE-2007-2869", "CVE-2007-2870", "CVE-2007-2871");
 
 name["english"] = "Fedora Core 7 2007-0001: epiphany";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the epiphany package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"epiphany-2.18.1-3.fc7", prefix:"epiphany-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"epiphany-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-1362", value:TRUE);
 set_kb_item(name:"CVE-2007-1562", value:TRUE);
 set_kb_item(name:"CVE-2007-2867", value:TRUE);
 set_kb_item(name:"CVE-2007-2868", value:TRUE);
 set_kb_item(name:"CVE-2007-2869", value:TRUE);
 set_kb_item(name:"CVE-2007-2870", value:TRUE);
 set_kb_item(name:"CVE-2007-2871", value:TRUE);
}
