#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-0186 (NetworkManager).

NetworkManager attempts to keep an active network connection available at all
times.  It is intended only for the desktop use-case, and is not intended for
usage on servers.   The point of NetworkManager is to make networking
configuration and setup as painless and automatic as possible.  If using DHCP,
NetworkManager is _intended_ to replace default routes, obtain IP addresses
from a DHCP server, and change nameservers whenever it sees fit.

-
Update Information:

A buffer overflow flaw was found in the debugging code of Fedora's version of w
pa_supplicant.  This can be triggered by those using NetworkManager.

It is recommended that users of wpa_supplicant or NetworkManager update to this
package (and the accompanying wpa_supplicant packages) which removes the affec
ted debug code.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27655);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Fedora Core 7 2007-0186: NetworkManager";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the NetworkManager package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"NetworkManager-0.6.5-3.fc7", prefix:"NetworkManager-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
