#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-0316 (mod_perl).

Mod_perl incorporates a Perl interpreter into the Apache web server,
so that the Apache web server can directly execute Perl code.
Mod_perl links the Perl runtime library into the Apache web server and
provides an object-oriented Perl interface for Apache's C language
API.  The end result is a quicker CGI script turnaround process, since
no external Perl interpreter has to be started.

Install mod_perl if you're installing the Apache web server and you'd
like for it to directly incorporate a Perl interpreter.

-
Update Information:

This update fixes a security issue in mod_perl.

An issue was found in the 'namespace_from_uri' method of the ModPerl::RegistryC
ooker class. If a server implemented a mod_perl registry module using this meth
od, a remote attacker requesting a carefully crafted URI can cause resource con
sumption, which could lead to a denial of service. (CVE-2007-1349)


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27658);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-1349");
 
 name["english"] = "Fedora Core 7 2007-0316: mod_perl";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mod_perl package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"mod_perl-2.0.3-9.1.fc7", prefix:"mod_perl-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"mod_perl-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-1349", value:TRUE);
}
