#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24191);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "Fedora Core 6 2007-035: xorg-x11-server";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-035 (xorg-x11-server).

X.Org X11 X server



Update information :

* Tue Jan  9 2007 Adam Jackson <ajax redhat com> 1.1.1-47.4.fc6
- xorg-xserver-1.1.0-dbe-render.diff: CVE #2006-6101.


Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xorg-x11-server package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"xorg-x11-server-1.1.1-47.4.fc6", prefix:"xorg-x11-server-", release:"FC6") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
