#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-0368 (perl-mecab).

Perl binding for MeCab.

-
Update Information:

This updates is for perl side binding of MeCab associated with MeCab itself.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27661);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Fedora Core 7 2007-0368: perl-mecab";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the perl-mecab package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"perl-mecab-0.96-1.fc7", prefix:"perl-mecab-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
