#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-0464 (evolution-data-server).

The evolution-data-server package provides a unified backend for programs
that work with contacts, tasks, and calendar information.

It was originally developed for Evolution (hence the name), but is now used
by other packages.

-
Update Information:

This update fixes a security flaw in Evolution's IMAP module.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27667);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Fedora Core 7 2007-0464: evolution-data-server";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the evolution-data-server package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"evolution-data-server-1.10.2-3.fc7", prefix:"evolution-data-server-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
