#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-0469 (phpPgAdmin).

phpPgAdmin is a fully functional web-based administration utility for
a PostgreSQL database server. It handles all the basic functionality
as well as some advanced features such as triggers, views and
functions (stored procedures). It also has Slony-I support.

-
Update Information:

This release includes a high-level security fix. All users must upgrade as soon
as possible:

[8]http://nvd.nist.gov/nvd.cfm?cvename=CVE-2007-2865




Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27668);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-2865");
 
 name["english"] = "Fedora Core 7 2007-0469: phpPgAdmin";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the phpPgAdmin package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"phpPgAdmin-4.1.2-1.fc7", prefix:"phpPgAdmin-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"phpPgAdmin-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-2865", value:TRUE);
}
