#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-0544 (thunderbird).

Mozilla Thunderbird is a standalone mail and newsgroup client.

-
Update Information:

This update fixes two security issues found in the 2.0.0.0 version of Thunderbi
rd.

Details at:
[8]http://www.mozilla.org/security/announce/2007/mfsa2007-12.html
[9]http://www.mozilla.org/security/announce/2007/mfsa2007-15.html

Users of Thunderbird are recommended to update to this erratum package which fi
xes those issues.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27670);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-1558", "CVE-2007-2867", "CVE-2007-2868");
 
 name["english"] = "Fedora Core 7 2007-0544: thunderbird";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the thunderbird package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"thunderbird-2.0.0.4-1.fc7", prefix:"thunderbird-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"thunderbird-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-1558", value:TRUE);
 set_kb_item(name:"CVE-2007-2867", value:TRUE);
 set_kb_item(name:"CVE-2007-2868", value:TRUE);
}
