#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24197);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-6104");
 
 name["english"] = "Fedora Core 6 2007-067: mono";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-067 (mono).

The Mono runtime implements a JIT engine for the ECMA CLI
virtual machine (as well as a byte code interpreter, the
class loader, the garbage collector, threading system and
metadata access libraries.

Update Information:

A security problem was found and fixed in mono class
libraries that affects the Mono web server implementation.

By appending spaces to URLs attackers could download the
source code of ASP.net scripts that would normally get
executed by the web server.

After upgrading the packages you need to restart any running
mono web server.


Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mono package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"mono-web-1.1.17.1-4.fc6", release:"FC6") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"mono-", release:"FC6") )
{
 set_kb_item(name:"CVE-2006-6104", value:TRUE);
}
