#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-0700 (firestarter).

Firestarter is an easy-to-use, yet powerful, Linux firewall tool for GNOME.
Use it to quickly set up a secure environment using the firewall creation
wizard, or use it's monitoring and administrating features with your old
firewall scripts.

-
ChangeLog:


Update information :

* Tue Jun 26 2007 Damien Durand <splinux fedoraproject org> - 1.0.3-16
- Fix BR
- Fix active connections status


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27674);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Fedora Core 7 2007-0700: firestarter";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the firestarter package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"firestarter-1.0.3-16.fc7", prefix:"firestarter-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
