#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-0791 (ekg).

EKG ('Eksperymentalny Klient Gadu-Gadu') is an open source gadu-gadu
client for UNIX systems. Gadu-Gadu is an instant messaging program,
very popular in Poland.

EKG features include:
- irssi-like ncurses interface
- sending and receiving files
- voice conversations
- launching shell commands on certain events
- reading input from pipe
- python scripting support
- speech synthesis (using an external program)
- encryption support

Please note that the program is not internationalized and all messages
are in Polish (although the commands are in English).

-
Update Information:

Numerous bugfixes (including security), support for the latest GG protocol vers
ion.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27680);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-1663", "CVE-2007-1664", "CVE-2007-1665");
 
 name["english"] = "Fedora Core 7 2007-0791: ekg";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ekg package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"ekg-1.7-1.fc7", prefix:"ekg-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"ekg-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-1663", value:TRUE);
 set_kb_item(name:"CVE-2007-1664", value:TRUE);
 set_kb_item(name:"CVE-2007-1665", value:TRUE);
}
