#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-0847 (php-pear-Structures-DataGrid-DataSource-MDB2).

This is a DataSource driver for Structures_DataGrid using PEAR::MDB2 and an
SQL query.

-
Update Information:

Security fix: users could manipulate the generated sorting queries


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27683);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Fedora Core 7 2007-0847: php-pear-Structures-DataGrid-DataSource-MDB2";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the php-pear-Structures-DataGrid-DataSource-MDB2 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"php-pear-Structures-DataGrid-DataSource-MDB2-0.1.10-1.fc7", prefix:"php-pear-Structures-DataGrid-DataSource-MDB2-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
