#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-1340 (GraphicsMagick).

GraphicsMagick is a comprehensive image processing package which is initially
based on ImageMagick 5.5.2, but which has undergone significant re-work by
the GraphicsMagick Group to significantly improve the quality and performance
of the software.

-
Update Information:

Maintainance update fixing several security issues and bugs.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27710);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2005-4601", "CVE-2006-0082", "CVE-2006-4144", "CVE-2006-5456", "CVE-2007-1797");
 
 name["english"] = "Fedora Core 7 2007-1340: GraphicsMagick";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the GraphicsMagick package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"GraphicsMagick-1.1.8-2.fc7", prefix:"GraphicsMagick-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"GraphicsMagick-", release:"FC7") )
{
 set_kb_item(name:"CVE-2005-4601", value:TRUE);
 set_kb_item(name:"CVE-2006-0082", value:TRUE);
 set_kb_item(name:"CVE-2006-4144", value:TRUE);
 set_kb_item(name:"CVE-2006-5456", value:TRUE);
 set_kb_item(name:"CVE-2007-1797", value:TRUE);
}
