#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-1442 (mediawiki).

MediaWiki is the software used for Wikipedia and the other Wikimedia
Foundation websites. Compared to other wikis, it has an excellent
range of features and support for high-traffic websites using multiple
servers

This package supports wiki farms. Copy /var/www/wiki over to the
desired wiki location and configure it through the web
interface. Remember to remove the config dir after completing the
configuration.

-
Update Information:

This update fixes the following vulnerability:

'Cross-site scripting (XSS) vulnerability in the AJAX features in
index.php in MediaWiki 1.6.x through 1.9.2, when $wgUseAjax is
enabled, allows remote attackers to inject arbitrary web script
or HTML via a UTF-7 encoded value of the rs parameter, which is
processed by Internet Explorer.'



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27715);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-1054");
 
 name["english"] = "Fedora Core 7 2007-1442: mediawiki";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mediawiki package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"mediawiki-1.9.3-34.0.2.fc7", prefix:"mediawiki-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"mediawiki-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-1054", value:TRUE);
}
