#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-1581 (qtpfsgui).

Qtpfsgui is a graphical program for assembling bracketed photos into High
Dynamic Range (HDR) images.  It also provides a number of tone-mapping
operators for creating low dynamic range versions of HDR images.

-
ChangeLog:


Update information :

* Sun Aug 12 2007 Douglas E. Warner <silfreed silfreed net> 1.8.12-1
- update to version 1.8.12
- fixes CVE-2007-2956; bug#251674


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27722);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-2956");
 
 name["english"] = "Fedora Core 7 2007-1581: qtpfsgui";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the qtpfsgui package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"qtpfsgui-1.8.12-1.fc7", prefix:"qtpfsgui-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"qtpfsgui-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-2956", value:TRUE);
}
