#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-1620 (Terminal).

Terminal is a lightweight and easy to use terminal emulator application
for the X windowing system, with some new ideas and features that make
it unique among X terminal emulators.

-
ChangeLog:


Update information :

* Tue Aug 14 2007 Kevin Fenzi <kevin tummy com> - 0.2.6-3
- Add patch for CVE-2007-3770.
- Update License tag


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27725);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-3770");
 
 name["english"] = "Fedora Core 7 2007-1620: Terminal";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Terminal package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"Terminal-0.2.6-3.fc7", prefix:"Terminal-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"Terminal-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-3770", value:TRUE);
}
