#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-1778 (bochs).

Bochs is a portable x86 PC emulation software package that emulates
enough of the x86 CPU, related AT hardware, and BIOS to run DOS,
Windows '95, Minix 2.0, and other OS's, all on your workstation.

-
Update Information:

This security update of bochs fixes CVE-2007-2894:

The emulated floppy disk controller in Bochs 2.3 allows local users of the gues
t operating system to cause a denial of service (virtual machine crash) via uns
pecified vectors, resulting in a divide-by-zero error.



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27733);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-2893", "CVE-2007-2894");
 
 name["english"] = "Fedora Core 7 2007-1778: bochs";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the bochs package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"bochs-2.3-7.fc7", prefix:"bochs-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"bochs-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-2893", value:TRUE);
 set_kb_item(name:"CVE-2007-2894", value:TRUE);
}
