#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-1793 (pam_ssh).

This PAM module provides single sign-on behavior for UNIX using SSH keys.
Users are authenticated by decrypting their SSH private keys with the
password provided. In the first PAM login session phase, an ssh-agent
process is started and keys are added. The same agent is used for the
following PAM sessions. In any case the appropriate environment variables
are set in the session phase.

-
ChangeLog:


Update information :

* Thu Aug 23 2007 Patrice Dumas <pertusus free fr> 1.92-2
- update to 1.92
- Fix #253959, CVE-2007-0844


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27735);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-0844");
 
 name["english"] = "Fedora Core 7 2007-1793: pam_ssh";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the pam_ssh package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"pam_ssh-1.92-2.fc7", prefix:"pam_ssh-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"pam_ssh-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-0844", value:TRUE);
}
