#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-1841 (sylpheed).

This program is an X based fast email client which has features
like:
o user-friendly and intuitive interface
o integrated NetNews client (partially implemented)
o ability of keyboard-only operation
o Mew/Wanderlust-like key bind
o multipart MIME
o unlimited multiple account handling
o message queueing
o assortment function
o XML-based address book

See /usr/share/doc/sylpheed*/README for more information.

-
Update Information:

Ulf Harnhammar (Secunia Research) has discovered a format string vulnerability
in sylpheed and claws-mail in inc_put_error() function in src/inc.c when displa
ying POP3 error reply.

Problem can be exploited by malicious POP3 server via specially crafted POP3 se
rver replies containing format specifiers.

Successful exploitation may allow execution of arbitrary code, but requires tha
t the user is tricked into connecting to a malicious POP3 server.

Secunia advisory: [8]http://secunia.com/advisories/26550/



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27736);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-2958");
 
 name["english"] = "Fedora Core 7 2007-1841: sylpheed";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the sylpheed package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"sylpheed-2.3.1-5", prefix:"sylpheed-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"sylpheed-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-2958", value:TRUE);
}
