#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-1853 (bugzilla).

Bugzilla is a popular bug tracking system used by multiple open source
projects.  It requires a database engine installed - either MySQL or
PostgreSQL.  Without one of these database engines, Bugzilla will not work.

-
Update Information:

Update to upstream version 3.0.1 for included security fixes


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27738);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Fedora Core 7 2007-1853: bugzilla";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the bugzilla package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"bugzilla-3.0.1-0.fc7", prefix:"bugzilla-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
