#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-1977 (vavoom).

Vavoom is an enhanced open-source port of Doom. Allowing you to play not only
the classic 3D first-person shooter Doom, but also the Doom derived classics
Heretic, Hexen and Strife. Compared to the original games it adds extra
features such as translucency and freelook support and ofcourse the capability
to play these classics under Linux.

-
Update Information:

Security update fixing various format strings vulnerabilities and a DOS vulnera
bility in the vavoom server, this fixes: CVE-2007-4533, CVE-2007-4534 & CVE-200
7-4535. Also see bugzilla bug 256621.



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27741);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-4533", "CVE-2007-4534", "CVE-2007-4535");
 
 name["english"] = "Fedora Core 7 2007-1977: vavoom";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the vavoom package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"vavoom-1.24-3.fc7", prefix:"vavoom-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"vavoom-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-4533", value:TRUE);
 set_kb_item(name:"CVE-2007-4534", value:TRUE);
 set_kb_item(name:"CVE-2007-4535", value:TRUE);
}
