#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2018 (mapserver).

Mapserver is an internet mapping program that converts GIS data to
map images in real time. With appropriate interface pages,
Mapserver can provide an interactive internet map based on
custom GIS data.

-
ChangeLog:


Update information :

* Thu Aug 30 2007 Oliver Falk <oliver linux-kernel at> 4.10.3-2
- Add fix to include libmapserver (in some places), instead of
libmap, that doesn't exist (anymore)


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27745);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-4542", "CVE-2007-4629");
 
 name["english"] = "Fedora Core 7 2007-2018: mapserver";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mapserver package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"mapserver-4.10.3-2.fc7", prefix:"mapserver-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"mapserver-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-4542", value:TRUE);
 set_kb_item(name:"CVE-2007-4629", value:TRUE);
}
