#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2020 (gallery2).

The base Gallery 2 installation - the equivalent of upstream's -minimal
package.  This package requires a database to be operational.  Acceptable
database backends include MySQL v 3.x, MySQL v 4.x, PostgreSQL v 7.x,
PostgreSQL v 8.x, Oracle 9i, Oracle 10g, DB2, and MS SQL Server.  All given
package versions are minimums, greater package versions are acceptable.

-
Update Information:

Security fix release for Gallery 2.2 series.

CVE text:
Multiple unspecified vulnerabilities in Gallery before 2.2.3 allow
attackers to (1) rename items, (2) read and modify item properties, or (3) loc
k and replace items via unknown vectors in (a) the WebDAV module; and (4) edit
unspecified data files using 'linked items' in (a) WebDAV and (b) Reupload modu
les.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27746);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-4650");
 
 name["english"] = "Fedora Core 7 2007-2020: gallery2";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gallery2 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"gallery2-2.2-0.7.svn20070831.fc7", prefix:"gallery2-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"gallery2-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-4650", value:TRUE);
}
