#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2055 (gd).

The gd graphics library allows your code to quickly draw images
complete with lines, arcs, text, multiple colors, cut and paste from
other images, and flood fills, and to write out the result as a PNG or
JPEG file. This is particularly useful in Web applications, where PNG
and JPEG are two of the formats accepted for inline images by most
browsers. Note that gd is not a paint program.

-
ChangeLog:


Update information :

* Wed Sep  5 2007 Ivana varekova <varekova redhat com> 2.0.35-1
- update to 2.0.35
- fix several vulnerabilities #277421


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27748);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-3472", "CVE-2007-3473", "CVE-2007-3474", "CVE-2007-3475", "CVE-2007-3476", "CVE-2007-3477", "CVE-2007-3478");
 
 name["english"] = "Fedora Core 7 2007-2055: gd";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gd package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"gd-2.0.35-1.fc7", prefix:"gd-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"gd-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-3472", value:TRUE);
 set_kb_item(name:"CVE-2007-3473", value:TRUE);
 set_kb_item(name:"CVE-2007-3474", value:TRUE);
 set_kb_item(name:"CVE-2007-3475", value:TRUE);
 set_kb_item(name:"CVE-2007-3476", value:TRUE);
 set_kb_item(name:"CVE-2007-3477", value:TRUE);
 set_kb_item(name:"CVE-2007-3478", value:TRUE);
}
