#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2060 (snort).

Snort is a libpcap-based packet sniffer/logger which
can be used as a lightweight network intrusion detection system.
It features rules based logging and can perform protocol analysis,
content searching/matching and can be used to detect a variety of
attacks and probes, such as buffer overflows, stealth port scans,
CGI attacks, SMB probes, OS fingerprinting attempts, and much more.
Snort has a real-time alerting capabilty, with alerts being sent to syslog,
a separate 'alert' file, or as a WinPopup message via Samba's smbclient

Edit /etc/snort.conf to configure snort and use snort.d to start snort

This rpm is different from previous rpms and while it will not clobber
your current snortd file, you will need to modify it.

There are 9 different packages available

All of them require the base snort rpm.  Additionally, you will need
to chose a binary to install.

/usr/sbin/snort should end up being a symlink to a binary in one of
the following configurations:

plain      plain+flexresp
mysql      mysql+flexresp
postgresql postgresql+flexresp
snmp       snmp+flexresp
bloat      mysql+postgresql+flexresp+snmp

Please see the documentation in /usr/share/doc/snort-2.7.0.1

There are no rules in this package  the license  they are released under forbid
s
us from repackaging them  and redistributing them.

-
Update Information:

This build moves from manual linking to alternatives.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27749);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2006-5276");
 
 name["english"] = "Fedora Core 7 2007-2060: snort";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the snort package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"snort-2.7.0.1-3.fc7", prefix:"snort-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"snort-", release:"FC7") )
{
 set_kb_item(name:"CVE-2006-5276", value:TRUE);
}
