#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2108 (qgit).

With qgit you are able to browse revisions history, view patch content
and changed files, graphically following different development branches.

-
Update Information:

- update to upstream version 1.5.7
- fixes #268381
- updated license tag


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27751);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-4631");
 
 name["english"] = "Fedora Core 7 2007-2108: qgit";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the qgit package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"qgit-1.5.7-1.fc7", prefix:"qgit-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"qgit-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-4631", value:TRUE);
}
