#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2216 (qt).

Qt is a GUI software toolkit which simplifies the task of writing and
maintaining GUI (Graphical User Interface) applications
for the X Window System.

Qt is written in C++ and is fully object-oriented.

This package contains the shared library needed to run qt
applications, as well as the README files for qt.

-
ChangeLog:


Update information :

* Mon Sep 17 2007 Than Ngo <than redhat com> - 1:3.3.8-7
- bz292941, CVE-2007-4137


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27760);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-3388", "CVE-2007-4137");
 
 name["english"] = "Fedora Core 7 2007-2216: qt";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the qt package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"qt-3.3.8-7.fc7", prefix:"qt-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"qt-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-3388", value:TRUE);
 set_kb_item(name:"CVE-2007-4137", value:TRUE);
}
