#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2295 (ntfs-3g).

The ntfs-3g driver is an open source, GPL licensed, third generation
Linux NTFS driver. It provides full read-write access to NTFS, excluding
access to encrypted files, writing compressed files, changing file
ownership, access right.

Technically its based on and a major improvement to the third
generation Linux NTFS driver, ntfsmount. The improvements include
functionality, quality and performance enhancements.

ntfs-3g features are being merged to ntfsmount. In the meanwhile,
ntfs-3g is currently the only free, as in either speech or beer, NTFS
driver for Linux that supports unlimited file creation and deletion.

-
Update Information:

It was discovered that members of the group fuse can get access to devices whic
h they normally should not have access to. For ntfs-3g mounts, this was because
/sbin/mount.ntfs-3g was setuid root.    This update fixes /sbin/mount.ntfs-3g
so that it is no longer has the setuid bit enabled. The fuse package is also be
ing updated to correct an error in the previous testing package which incorrect
ly changed the permissions on /dev/fuse.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27764);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Fedora Core 7 2007-2295: ntfs-3g";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ntfs-3g package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"ntfs-3g-1.913-2.fc7", prefix:"ntfs-3g-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
