#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2530 (openssl).

The OpenSSL toolkit provides support for secure communications between
machines. OpenSSL includes a certificate management tool and shared
libraries which provide various cryptographic algorithms and
protocols.

-
Update Information:

This is important security update.



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27777);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-3108", "CVE-2007-4995", "CVE-2007-5135");
 
 name["english"] = "Fedora Core 7 2007-2530: openssl";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the openssl package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"openssl-0.9.8b-15.fc7", prefix:"openssl-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"openssl-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-3108", value:TRUE);
 set_kb_item(name:"CVE-2007-4995", value:TRUE);
 set_kb_item(name:"CVE-2007-5135", value:TRUE);
}
