#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-256 (gnucash).

GnuCash is a personal finance manager. A check-book like register GUI
allows you to enter and track bank accounts, stocks, income and even
currency trades. The interface is designed to be simple and easy to
use, but is backed with double-entry accounting principles to ensure
balanced books.

Update Information:

This updates GnuCash to version 2.0.5, the latest upstream
release.

Major changes in this release include;
o Fix some strings not being translated.
o Use guiles native sort and record.
o Adjust how payment dialog resizes.
o Don't abort when F::Q fails to return a quote.
o Change Russian Ruble from RUR to RUB.
o Fix security problem with tmp filesystem and symlink
attack. (CVE-2007-0007)
o Add French and Canadian French translation updates.
o Do not crash on delete_event in new user dialog.
o Add sanity checks when accessing GncPluginPage.
o Make new windows the same size as the active one.
o The New Turkish Lira changed from TRL to TRY in 2005.

Thanks to Sami Farin for uncovering the /tmp file issue.



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24728);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-0007");
 
 name["english"] = "Fedora Core 6 2007-256: gnucash";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gnucash package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"gnucash-2.0.5-1.fc6", release:"FC6") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"gnucash-", release:"FC6") )
{
 set_kb_item(name:"CVE-2007-0007", value:TRUE);
}
