#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2564 (tk).

When paired with the Tcl scripting language, Tk provides a fast and powerful
way to create cross-platform GUI applications.

-
Update Information:

Buffer overflow in the ReadImage function in generic/tkImgGIF.c in Tcl (Tcl/Tk)
before 8.4.16 allows remote attackers to execute arbitrary code via multi-fram
e interlaced GIF files in which later frames are smaller than the first.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27778);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5137");
 
 name["english"] = "Fedora Core 7 2007-2564: tk";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tk package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"tk-8.4.13-6.fc7", prefix:"tk-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"tk-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-5137", value:TRUE);
}
