#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2613 (proftpd).

ProFTPD is an enhanced FTP server with a focus toward simplicity, security,
and ease of configuration. It features a very Apache-like configuration
syntax, and a highly customizable server infrastructure, including support for
multiple 'virtual' FTP servers, anonymous FTP, and permission-based directory
visibility.

This package defaults to the standalone behaviour of ProFTPD, but all the
needed scripts to have it run by xinetd instead are included.

-
Update Information:

The Auth API in ProFTPD before 20070417, when multiple simultaneous
authentication modules are configured, does not require that the module that ch
ecks authentication is the same as the module that retrieves authentication dat
a, which might allow remote attackers to bypass authentication, as demonstrated
by use of SQLAuthTypes Plaintext in mod_sql, with data retrieved from /etc/pas
swd.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27781);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-2165");
 
 name["english"] = "Fedora Core 7 2007-2613: proftpd";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the proftpd package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"proftpd-1.3.1-2.fc7", prefix:"proftpd-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"proftpd-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-2165", value:TRUE);
}
