#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2668 (epiphany-extensions).

Epiphany Extensions is a collection of extensions for Epiphany, the
GNOME web browser.

-
Update Information:

An update to Firefox (version 2.0.0.8) was recently pushed which resolves some
security issues.

Users of Blam and Epiphany Extensions are advised to upgrade to these erratum p
ackages, which have been rebuilt against the updated Firefox packages.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27788);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Fedora Core 7 2007-2668: epiphany-extensions";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the epiphany-extensions package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"epiphany-extensions-2.18.3-4", prefix:"epiphany-extensions-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
