#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2795 (seamonkey).

SeaMonkey is an all-in-one Internet application suite. It includes
a browser, mail/news client, IRC client, JavaScript debugger, and
a tool to inspect the DOM for web pages. It is derived from the
application formerly known as Mozilla Application Suite.

-
Update Information:

SeaMonkey is an open source Web browser, advanced email and newsgroup client, I
RC chat client, and HTML editor.

By leveraging browser flaws, users could be fooled into possibly surrendering s
ensitive information (CVE-2007-1095, CVE-2007-3511, CVE-2007-3844, CVE-2007-533
4).

Malformed web content could result in the execution of arbitrary commands (CVE-
2007-5338, CVE-2007-5339, CVE-2007-5340).

Digest Authentication requests can be used to conduct a response splitting atta
ck (CVE-2007-2292).

The sftp protocol handler could be used to view the contents of arbitrary local
files (CVE-2007-5337).

Users of SeaMonkey are advised to upgrade to these erratum packages, which cont
ain patches that correct these issues.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27805);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-1095", "CVE-2007-2292", "CVE-2007-3511", "CVE-2007-3844", "CVE-2007-5334", "CVE-2007-5337", "CVE-2007-5338", "CVE-2007-5339", "CVE-2007-5340");
 
 name["english"] = "Fedora Core 8 2007-2795: seamonkey";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the seamonkey package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"seamonkey-1.1.5-2.fc8", prefix:"seamonkey-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"seamonkey-", release:"FC8") )
{
 set_kb_item(name:"CVE-2007-1095", value:TRUE);
 set_kb_item(name:"CVE-2007-2292", value:TRUE);
 set_kb_item(name:"CVE-2007-3511", value:TRUE);
 set_kb_item(name:"CVE-2007-3844", value:TRUE);
 set_kb_item(name:"CVE-2007-5334", value:TRUE);
 set_kb_item(name:"CVE-2007-5337", value:TRUE);
 set_kb_item(name:"CVE-2007-5338", value:TRUE);
 set_kb_item(name:"CVE-2007-5339", value:TRUE);
 set_kb_item(name:"CVE-2007-5340", value:TRUE);
}
