#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-287 (php).

PHP is an HTML-embedded scripting language. PHP attempts to make it
easy for developers to write dynamically generated webpages. PHP also
offers built-in database integration for several commercial and
non-commercial database management systems, so writing a
database-enabled webpage with PHP is fairly simple. The most common
use of PHP coding is probably as a replacement for CGI scripts. The
mod_php module enables the Apache Web server to understand and process
the embedded PHP language in Web pages.

Update Information:

This update fixes a number of security issues in PHP.

A number of buffer overflow flaws were found in the PHP
session extension, the str_replace() function, and the
imap_mail_compose() function. If very long strings under
the control of an attacker are passed to the str_replace()
function then an integer overflow could occur in memory
allocation. If a script uses the imap_mail_compose()
function to create a new MIME message based on an input body
from an untrusted source, it could result in a heap
overflow. An attacker who is able to access a PHP
application affected by any these issues could trigger these
flaws and possibly execute arbitrary code as the 'apache'
user. (CVE-2007-0906)

If unserializing untrusted data on 64-bit platforms, the
zend_hash_init() function can be forced to enter an infinite
loop, consuming CPU resources for a limited length of time,
until the script timeout alarm aborts execution of the
script. (CVE-2007-0988)

If the wddx extension is used to import WDDX data from an
untrusted source, certain WDDX input packets may allow a
random portion of heap memory to be exposed. (CVE-2007-0908)

If the odbc_result_all() function is used to display data
from a database, and the contents of the database table are
under the control of an attacker, a format string
vulnerability is possible which could lead to the execution
of arbitrary code. (CVE-2007-0909)

A one byte memory read will always occur before the
beginning of a buffer, which could be triggered for example
by any use of the header() function in a script. However it
is unlikely that this would have any effect. (CVE-2007-0907)

Several flaws in PHP could allows attackers to 'clobber'
certain super-global variables via unspecified vectors.
(CVE-2007-0910)

The Fedora Project would like to thank Stefan Esser for his
help diagnosing these issues.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24717);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-4812", "CVE-2006-5465", "CVE-2007-0906", "CVE-2007-0907", "CVE-2007-0908", "CVE-2007-0909", "CVE-2007-0910", "CVE-2007-0988");
 
 name["english"] = "Fedora Core 5 2007-287: php";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the php package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"php-xml-5.1.6-1.4", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-ldap-5.1.6-1.4", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-pdo-5.1.6-1.4", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-xmlrpc-5.1.6-1.4", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-mbstring-5.1.6-1.4", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-5.1.6-1.4", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-odbc-5.1.6-1.4", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-snmp-5.1.6-1.4", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-soap-5.1.6-1.4", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-dba-5.1.6-1.4", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-devel-5.1.6-1.4", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-gd-5.1.6-1.4", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-ncurses-5.1.6-1.4", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-bcmath-5.1.6-1.4", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-pgsql-5.1.6-1.4", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-mysql-5.1.6-1.4", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-imap-5.1.6-1.4", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"php-", release:"FC5") )
{
 set_kb_item(name:"CVE-2006-4812", value:TRUE);
 set_kb_item(name:"CVE-2006-5465", value:TRUE);
 set_kb_item(name:"CVE-2007-0906", value:TRUE);
 set_kb_item(name:"CVE-2007-0907", value:TRUE);
 set_kb_item(name:"CVE-2007-0908", value:TRUE);
 set_kb_item(name:"CVE-2007-0909", value:TRUE);
 set_kb_item(name:"CVE-2007-0910", value:TRUE);
 set_kb_item(name:"CVE-2007-0988", value:TRUE);
}
