#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-293 (gnome-python2-extras).

The gnome-python-extra package contains the source packages for additional
Python bindings for GNOME. It should be used together with gnome-python.



Update information :

* Mon Feb 26 2007 Matthew Barnes <mbarnes redhat com> - 2.14.2-9.fc6
- Rebuild against firefox-1.5.0.10.



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24729);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "Fedora Core 6 2007-293: gnome-python2-extras";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gnome-python2-extras package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"gnome-python2-extras-2.14.2-9.fc6", prefix:"gnome-python2-extras-", release:"FC6") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
