#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2989 (hugin).

hugin can be used to stitch multiple images together. The resulting image can
span 360 degrees. Another common use is the creation of very high resolution
pictures by combining multiple images.  It uses the Panorama Tools as backend
to create high quality images

-
ChangeLog:


Update information :

* Mon Nov  5 2007 Bruno Postle <bruno postle net> 0.6.1-11
- fix for CVE-2007-5200 hugin unsafe temporary file usage
- bug #332401; bug #362851; bug #362861; bug #362871
- fix Source tag
- update license GPL -> GPLv2+


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28154);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5200");
 
 name["english"] = "Fedora Core 7 2007-2989: hugin";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the hugin package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"hugin-0.6.1-11.fc7", prefix:"hugin-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"hugin-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-5200", value:TRUE);
}
