#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-3074 (inotify-tools).

inotify-tools is a set of command-line programs for Linux providing
a simple interface to inotify. These programs can be used to monitor
and act upon filesystem events.

-
Update Information:

A vulnerability has been reported in inotify-tools, which can potentially be
exploited by malicious users to compromise an application using the library.

Successful exploitation may allow the execution of arbitrary code with
privileges of the application using the affected library.

NOTE: The programs shipped with inotify-tools are reportedly not affected.

The vulnerability is reported in versions prior to 3.11.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28160);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5037");
 
 name["english"] = "Fedora Core 7 2007-3074: inotify-tools";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the inotify-tools package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"inotify-tools-3.11-1.fc7", prefix:"inotify-tools-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"inotify-tools-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-5037", value:TRUE);
}
